#include "Collide.h"

#include <math.h>

//initialisation du gnrateur de nbres aleatoires
inline void randomize(){
  srand((time_t) time(NULL));                           
}
//gnrateur de nbres alatoires entre 0 et n-1
inline int random(int n){
  return rand()%n;
}

//Objet physique fixe
CCollide::CCollide(float px,float py,float pz,float rayon,float coefElastic)
:pos(px,py,pz)
{
    this->coefElastic=coefElastic;
    this->rayon=rayon;
    isNotFixed=false;
    dmg=0;
    colid_flags=IN_LIFE;
}

CCollide::~CCollide()
{
}

//Fonction "callabck" en cas d'impact
void CCollide::applyCollision(Vecteur pImpact,Vecteur forceImpact,float ampliImpact,float masse,unsigned char dmg)
{
}

void CCollide::applyExplosion(float dmg,float proxi)
{
}

//MAJ et render
bool CCollide::frameMove(float elapsedTime)
{
    return false;//retourne false veut dire que l'objet ne doit pas tre dtruit
}

void CCollide::render()
{
    glPushMatrix();
    glTranslatef(pos.x,pos.y,pos.z);
    glutSolidSphere(rayon,16,16);
    glPopMatrix();
}

//Changer des drapeaux du collide (si il est vivant ou non etc...)
void CCollide::cldEnable(unsigned char colid_flags)
{
    (this->colid_flags)|=colid_flags;
}

void CCollide::cldDisable(unsigned char colid_flags)
{
    //__asm("notb (%EBP+8)");
    (this->colid_flags)&=(0xFF-colid_flags);
}















//Objet physique en mouvement
CCollideMv::CCollideMv(float px,float py,float pz,float fx,float fy,float fz,float vx,float vy,float vz,float masse,float rayon,float coefElastic,float ffrot)
:CCollide(px,py,pz,rayon,coefElastic),force(fx,fy,fz),vel(vx,vy,vz)
{
    this->masse=masse;
    this->ffrot=ffrot;
    isNotFixed=true;
}

CCollideMv::~CCollideMv()
{
}

void CCollideMv::applyCollision(Vecteur pImpact,Vecteur forceImpact,float ampliImpact,float masse)
{
}

void CCollideMv::applyExplosion(float dmg,float proxi)
{
}

bool CCollideMv::frameMove(float elapsedTime)
{
    return false;
}

void CCollideMv::render()
{
    glPushMatrix();
    glTranslatef(pos.x,pos.y,pos.z);
    glutSolidSphere(rayon,16,16);
    glPopMatrix();
}

















//Objet qui dfinit une zone en combustion
//tout objet physique qui y passe doit subir des dgats
CExplosion::CExplosion(float px,float py,float pz,float rayon,float dmg,float life)
:pos(px,py,pz)
{
    this->rayon=rayon;
    this->dmg=dmg;
    this->life=life;
}

CExplosion::~CExplosion()
{
}

bool CExplosion::frameMove(float elapsedTime)
{
    return false;
}

void CExplosion::render()
{
    glPushMatrix();
    glTranslatef(pos.x,pos.y,pos.z);
    glutSolidSphere(rayon,16,16);
    glPopMatrix();
}
















//Moteur de collisions
CMoteurCollide::CMoteurCollide()
{
    gravity=0.000097;
    tr=NULL;
    cld1=cld2=NULL;
}

CMoteurCollide::~CMoteurCollide()
{
    clear();
}

//Dtruire tout les collides dans le moteur
void CMoteurCollide::clear()
{
    vector<CCollide*>::iterator it;
    for(it=vectColl.begin();it!=vectColl.end();it++)delete (*it);
    vectColl.clear();
    
    vector<CExplosion*>::iterator itE;
    for(itE=vectExplo.begin();itE!=vectExplo.end();itE++)delete (*itE);
    vectExplo.clear();
    
    cld1=cld2=NULL;
}

//Retourne le temps avant la premire collisions
//cld1 et cld2 seront les 2 collides responsable de la collision.
//sinon il retourne elapsedTime au cas o il n'y a pas de collisions
float CMoteurCollide::getTheNearestCollision(float elapsedTime)
{
    cld1=cld2=NULL;
    vector<CCollide*>::iterator it1,it2,mx,mxP;
    
    Vecteur p,v;
    
    float r,a,b,delta;
    
    CCollide *c1,*c2,*tc;
    
    //Le switch permet de mettre bou  bou 2 vectors.
    //lorsque l'on a finit de parcourir vectColl on passe  vectLsr
    //comme si il ne faitsait qu'un vecteur.
    bool switch1,switch2;
    switch1=true;
    
    //on est oblig de sparer les vectLsr car il faut les afficher avec du Blend
    
    mxP=vectColl.end();
    mx=vectLsr.end();
    //O(n) n= nombre d'objets
    for(it1=vectColl.begin();it1!=mx;it1++)
    {
        if(switch1)
        {
            if(it1==mxP)
            {
                switch1=false;
                it1=vectLsr.begin();
                if(it1==mx)break;
                switch2=false;
            }
            else switch2=true;
        }
        else switch2=false;
        
        tc=*it1;
        if(!(tc->colid_flags & IN_LIFE))continue; // si c1 est mort on passe au suivant
        
        //avant je comptait grer les collisions avec le terrain mais je n'ai pas eu le temps de rectifier
        /*
        if(tr && tc->isNotFixed)
        {
            a=tr->getIntersec(c1->pos,((CCollideMv*)tc)->vel,elapsedTime,c1->rayon,0.5);
            if(a>0.000000001 && a<elapsedTime)
            {
                elapsedTime=a;
                cld1=c1;
                cld2=NULL;
            }
        }
        */
        
        //on parcour les objets aprs celui point par it1
        //car tout les objets avant it1 ont dj t tests avec tout les autres
        for(it2=it1+1;it2!=mx;it2++)
        {
            if(switch2 && (it2==mxP))
            {
                switch2=false;
                it2=vectLsr.begin();
                if(it2==mx)break;
                switch2=false;
            }
            c2=*it2;
            
            if(!(c2->colid_flags & IN_LIFE))continue;//si jamais c2 n'est pas en vie alors on passe au suivant
            
            c1=tc;
            
            if(c1->isNotFixed || c2->isNotFixed)//si l'un des 2 objets est en mouvement
            {
                if(!(c2->isNotFixed))//Si c2 est fixe alors on change avec c1
                {
                    c2=c1;
                    c1=*it2;
                }
                
                //Rsolution de l'quation de la sphre
                //si la collision a lieu avant elapsedTime alors
                //on la prend en compte en indiquant que le elapsedTime
                //ira jusqu' cette collision.
                r=c1->rayon+c2->rayon;
                p=c2->pos;
                p-=c1->pos;
                v=((CCollideMv*)c2)->vel;
                
                if(c1->isNotFixed)v-=((CCollideMv*)c1)->vel;
                
                r*=r;
                r=p*p-r;
                if(r<-0.000000001)
                {
                    cld1=c1;
                    cld2=c2;
                    return -1.0;
                }
                
                b=p*v;
                if(b<=0.0)
                {
                    a=v*v;
                    
                    if(a>0.0)
                    {
                        delta=b*b-a*r;
                        
                        if(delta>0.0)
                        {
                            r=(-b-sqrtf(delta))/a;
                            if(r<elapsedTime)
                            {
                                elapsedTime=r;
                                cld1=c1;
                                cld2=c2;
                            }
                        }
                        else if(delta==0.0)
                        {
                            r=(-b)/a;
                            if(r<elapsedTime)
                            {
                                elapsedTime=r;
                                cld1=c1;
                                cld2=c2;
                            }
                        }
                    }//if a
                }//if b
            }// if One is not Fixed
        }// for2
    }//for 1
    
    return elapsedTime;
}

#define COLIDMXSTEP 90.0
#define SECUMAXCPT 1000

//On met  jours les objets dans le moteur
void CMoteurCollide::frameMove(float elapsedTime)
{
    float cutElapsedTime;
    
    vector<CCollide*>::iterator it,mxP,mx;
    vector<CExplosion*>::iterator iExp,mexp;
    
    CExplosion *ed;
    CCollide *c1;
    Vecteur n,p,v1,v2;
    float t,cfEl,vA,vB;
    
    unsigned char cpt;
    unsigned short secuCpt;
    float r,a,b,delta;
    
    CCollide *oldCld1,*oldCld2;
    
    //Mme principe on switch d'un vecteur  l'autre lorsque l'on est arriv au bou
    //de l'un
    bool switch1;
    while(elapsedTime>0.0000000001)//tant qu'il reste du temps  couller
    {
        //Si il y a eu un gros coup de lague alors on dcoupe le temps en COLIDMXSTEP ms
        if(elapsedTime>=COLIDMXSTEP)cutElapsedTime=COLIDMXSTEP;
        else cutElapsedTime=elapsedTime;
        cpt=0;//compteur de collision au cas o 2 objets rentre en collision trop de fois  la suite
        secuCpt=0;//Compteur de scurit au cas o il y a une collision sans solution
        do
        {
            oldCld1=cld1;
            oldCld2=cld2;
            if(secuCpt>SECUMAXCPT)
            {
             t=cutElapsedTime;//application de la scurit => pas de collision gre
             cld1=cld2=NULL;
            }
            else
            {
                t=getTheNearestCollision(cutElapsedTime);//on calcul la collision la plus proche dans le temps
                if(t<cutElapsedTime)t-=0.00000001;
                secuCpt++;
            }
            
            if(t>0.0)//Si elle est en avance dans le temps
            {
                //On met  jours les collides jusqu' t
                //et on gre la rposne de la collision si il y en a eu une
                cutElapsedTime-=t;
                //Faire progresser les collides et appliquer la collision.
                switch1=true;
                mxP=vectColl.end();
                mx=vectLsr.end();
                for(it=vectColl.begin();it!=mx;it++)
                {
                    if(switch1 && it==mxP)
                    {
                        switch1=false;
                        it=vectLsr.begin();
                        if(it==mx)break;
                    }
                    
                    c1=*it;
                    if(c1->isNotFixed)
                    {
                        v1=((CCollideMv*)c1)->vel;
                        
                        mexp=vectExplo.end();
                        for(iExp=vectExplo.begin();iExp!=mexp;iExp++)
                        {
                            ed=*iExp;
                            
                            r=c1->rayon+ed->rayon;
                            p=c1->pos;
                            p-=ed->pos;
                            
                            b=p*v1;
                            if(b<=0.0)
                            {
                                a=v1*v1;
                                if(a>0.0)
                                {
                                    r*=r;
                                    r=p*p-r;
                                    delta=b*b-a*r;
                                    
                                    if(delta>0.0)
                                    {
                                        delta=sqrtf(delta);
                                        
                                        r=(-b-delta)/a;
                                        if(r<0.0)r=0.0;
                                        b=(-b+delta)/a;
                                        
                                        if(r<=t)
                                        {
                                            if(b>t)b=t;
                                            c1->applyExplosion(ed->dmg,b-r);
                                        }
                                    }//if(delta>0.0)
                                }//if(a>0.0)
                            }//if(b<=0.0)
                        }//for(iExp=vectExplo.begin();iExp!=vectExplo.end();iExp++)
                        
                        //v1=((CCollideMv*)c1)->vel;
                        v1*=t;
                        ((CCollideMv*)c1)->pos+=v1;
                    }//if(c1->isNotFixed)
                    else
                    {
                        mexp=vectExplo.end();
                        for(iExp=vectExplo.begin();iExp!=mexp;iExp++)
                        {
                            ed=*iExp;
                            p=c1->pos;
                            p-=ed->pos;
                            
                            a=p*p;
                            r=c1->rayon+ed->rayon;
                            
                            if(a<r*r)
                            {
                                /*a=sqrtf(a);
                                r=1.0-a;
                                r*=r;*/
                                c1->applyExplosion(ed->dmg,t);
                            }//if(a<r*r)
                        }//for(iExp=vectExplo.begin();iExp!=vectExplo.end();iExp++)
                    }//if(c1->isNotFixed)
                }//for(it=vectColl.begin();it!=vectColl.end();it++)
                
                if(cld1)
                {
                    if(cld2)
                    {
                        if(oldCld1==cld1 && oldCld2==cld2)
                        {
                            if(cpt>5)
                            {
                                //if(cld1->isNotFixed)((CCollideMv*)cld1)->vel.inverse();
                                //if(cld2->isNotFixed)((CCollideMv*)cld2)->vel.inverse();
                                if(cld1->isNotFixed)
                                {
                                    if(cld1->isNotFixed)
                                    {
                                        ((CCollideMv*)cld1)->vel.x+=((((float)rand())/RAND_MAX)*2.0-1.0)*0.1;
                                        ((CCollideMv*)cld1)->vel.y+=((((float)rand())/RAND_MAX)*2.0-1.0)*0.1;
                                        ((CCollideMv*)cld1)->vel.z+=((((float)rand())/RAND_MAX)*2.0-1.0)*0.1;
                                    }
                                    
                                    if(cld2->isNotFixed)
                                    {
                                        ((CCollideMv*)cld2)->vel.x+=((((float)rand())/RAND_MAX)*2.0-1.0)*0.1;
                                        ((CCollideMv*)cld2)->vel.y+=((((float)rand())/RAND_MAX)*2.0-1.0)*0.1;
                                        ((CCollideMv*)cld2)->vel.z+=((((float)rand())/RAND_MAX)*2.0-1.0)*0.1;
                                    }
                                }
                                //continue;
                            }
                            else cpt++;
                        }
                        else cpt=0;
                        
                        n=cld2->pos;
                        n-=cld1->pos;
                        n/=(cld1->rayon+cld2->rayon);
                        p=n;
                        p*=cld1->rayon;
                        p+=cld1->pos;
                        
                        cfEl=(cld1->coefElastic+cld2->coefElastic)/2.0;
                        
                        if(cld1->isNotFixed)
                        {
                            t=(n*(((CCollideMv*)cld1)->vel));
                            if(t<0.0)t=0.0;
                            v1=n;v1*=t;
                            vA=-t;
                            
                            if(cld2->isNotFixed)
                            {
                                t=(n*(((CCollideMv*)cld2)->vel));
                                if(t>0.0)t=0.0;
                                v2=n;v2*=t;
                                vB=-t;
                                
                                cld2->applyCollision(p,n,vB-vA,((CCollideMv*)cld1)->masse,cld1->dmg);
                                n.inverse();
                                cld1->applyCollision(p,n,vB-vA,((CCollideMv*)cld2)->masse,cld2->dmg);
                                
                                ((CCollideMv*)cld1)->vel-=v1;
                                ((CCollideMv*)cld2)->vel-=v2;
                                
                                p.z=((CCollideMv*)cld1)->masse;
                                r=((CCollideMv*)cld2)->masse;
                                
                                p.x=(p.z-r)*0.98;
                                p.y=p.z+r;
                                
                                t=(2.0*r*vB*cfEl+vA*p.x)/p.y;
                                vB=(2.0*p.z*vA*cfEl-vB*p.x)/p.y;
                                
                                p=n;
                                p*=t;
                                ((CCollideMv*)cld1)->vel+=p;
                                
                                p=n;
                                p*=vB;
                                ((CCollideMv*)cld2)->vel+=p;
                            }//if(cld2->isNotFixed)
                            /*else
                            {
                                cld2->applyCollision(p,n,-vA,((CCollideMv*)cld1)->masse,cld1->dmg);
                                n.inverse();
                                //cld1->applyCollision(p,n,-vA,-1.0,cld2->dmg);
                                cld1->applyCollision(p,n,-vA,((CCollideMv*)cld1)->masse,cld2->dmg);
                                
                                ((CCollideMv*)cld1)->vel-=v1;
                                p=n;
                                p*=-vA*cfEl;
                                ((CCollideMv*)cld1)->vel+=p;
                            }//if(cld2->isNotFixed)*/
                        }//if(cld1->isNotFixed)
                        else
                        {
                            if(cld2->isNotFixed)
                            {
                                t=(n*(((CCollideMv*)cld2)->vel));
                                if(t>0.0)t=0.0;
                                vB=-t;
                                
                                v2=n;v2*=t;
                                
                                //cld2->applyCollision(p,n,vB,-1.0,cld1->dmg);
                                cld2->applyCollision(p,n,vB,((CCollideMv*)cld2)->masse,cld1->dmg);
                                n.inverse();
                                cld1->applyCollision(p,n,vB,((CCollideMv*)cld2)->masse,cld2->dmg);
                                
                                ((CCollideMv*)cld2)->vel-=v2;
                                p=n;
                                p*=-vB*cfEl;
                                ((CCollideMv*)cld2)->vel+=p;
                            }//if(cld2->isNotFixed)
                            //else
                            //{
                            //}
                        }//if(cld1->isNotFixed)
                        
                    }//if cld2
                    else
                    {
                        if(tr)
                        {
                            p=((CCollideMv*)cld1)->vel;
                            p.normalize();
                            p*=cld1->rayon;
                            p+=cld1->pos;
                            
                            tr->getNormal(n,cld1->pos.x,cld1->pos.z);
                            cld1->applyCollision(p,n,-vA,-1.0,0);
                            
                            t=(n*(((CCollideMv*)cld1)->vel));
                            if(t>0.0)t=0.0;
                            else
                            {
                                vA=-t*((cld1->coefElastic+0.5)/2.0);
                                v1=n;v1*=t;
                                ((CCollideMv*)cld1)->vel-=v1;
                                n*=vA;
                                ((CCollideMv*)cld1)->vel+=n;
                            }
                            
                            t=tr->getHeight(cld1->pos.x,cld1->pos.z);
                            if((cld1->pos.y-cld1->rayon)<t)cld1->pos.y=t+cld1->rayon;
                            
                            cld1->applyCollision(cld1->pos,((CCollideMv*)cld1)->vel,0.1,((CCollideMv*)cld1)->masse,0);
                        }
                    }////if cld2
                }//if cld1
            }
            else
            {
                //Sinon on ne reviens pas vraiment dans le temps mais on rattrape l'erreur
                //qui est que 2 collides sont en intersection.
                //donc on les repousses suivant si il sont fixe ou non
                //t+=-0.01;
                if(cld1)
                {
                    if(cld2)
                    {
                        /*
                        v1=cld1->vel;
                        v1*=t;
                        cld1->pos+=v1;
                        
                        v2=cld2->vel;
                        v2*=t;
                        cld2->pos+=v2;
                        */
                        
			                     if(oldCld1==cld1 && oldCld2==cld2)
                        {
                            if(cpt>5)
                            {
                                //if(cld1->isNotFixed)((CCollideMv*)cld1)->vel.inverse();
                                //if(cld2->isNotFixed)((CCollideMv*)cld2)->vel.inverse();
                                if(cld1->isNotFixed)
                                {
                                    if(cld1->isNotFixed)
                                    {
                                        ((CCollideMv*)cld1)->vel.x+=((((float)rand())/RAND_MAX)*2.0-1.0)*0.1;
                                        ((CCollideMv*)cld1)->vel.y+=((((float)rand())/RAND_MAX)*2.0-1.0)*0.1;
                                        ((CCollideMv*)cld1)->vel.z+=((((float)rand())/RAND_MAX)*2.0-1.0)*0.1;
                                    }
                                    
                                    if(cld2->isNotFixed)
                                    {
                                        ((CCollideMv*)cld2)->vel.x+=((((float)rand())/RAND_MAX)*2.0-1.0)*0.1;
                                        ((CCollideMv*)cld2)->vel.y+=((((float)rand())/RAND_MAX)*2.0-1.0)*0.1;
                                        ((CCollideMv*)cld2)->vel.z+=((((float)rand())/RAND_MAX)*2.0-1.0)*0.1;
                                    }
                                }
                                //continue;
                            }
                            else cpt++;
                        }
                        else cpt=0;
                        
                        n=cld2->pos;
                        n-=cld1->pos;
                        t=n.length();
                        
                        if(t>0.0){n/=t;}
                        else{n.x=1.0;n.y=0.0;n.z=0.0;}
                        t=(cld1->rayon+cld2->rayon-t+0.02);
                        if(t<0.0)t=0.0;
                        
                        if(cld1->isNotFixed)
                        {
                            if(cld2->isNotFixed)
                            {
                                t/=2.0;
                                n*=t;
                                cld2->pos+=n;n.inverse();cld1->pos+=n;
                            }
                            else
                            {
                                n*=-t;
                                cld1->pos+=n;
                            }
                        }
                        else
                        {
                            if(cld2->isNotFixed)
                            {
                                n*=t;
                                cld2->pos+=n;
                            }
                            else
                            {
                                t/=2.0;
                                n*=t;
                                cld2->pos+=n;n.inverse();cld1->pos+=n;
                            }
                        }
                    }//if cld2
                    /*else
                    {
                        if(tr)
                        {
                            v1=((CCollideMv*)cld1)->vel;
                            v1*=t;
                            ((CCollideMv*)cld1)->pos+=v1;
                            
                            tr->getNormal(n,cld1->pos.x,cld1->pos.z);
                            t=(n*(((CCollideMv*)cld1)->vel));
                            if(t>0.0)t=0.0;
                            else
                            {
                                vA=-t*((cld1->coefElastic+0.5)/2.0);
                                v1=n;v1*=t;
                                ((CCollideMv*)cld1)->vel-=v1;
                                n*=vA;
                                ((CCollideMv*)cld1)->vel+=n;
                            }

                            r=tr->getHeight(cld1->pos.x,cld1->pos.z);
                            if((cld1->pos.y-cld1->rayon)<r)cld1->pos.y=r+cld1->rayon;
                        }
                    }*/
                }//if cld1
            }
        }while(cutElapsedTime>0.0);
        
        if(elapsedTime>=COLIDMXSTEP)cutElapsedTime=COLIDMXSTEP;
        else cutElapsedTime=elapsedTime;
        elapsedTime-=cutElapsedTime;
        
        //MAJ des collides en tant que frameMove virtuel interne  l'objet
        it=vectLsr.begin();
        mx=vectLsr.end();
        while(it!=mx)
        {
            c1=*it;
            
            if(c1->frameMove(cutElapsedTime))
            {
                delete c1;
                vectLsr.erase(it);
                mx=vectLsr.end();
            }
            else 
            {
                if(c1->isNotFixed)
                {
                    if(tr)
                    {
                        t=tr->getHeight(c1->pos.x,c1->pos.z);
                        if((c1->pos.y-c1->rayon)<t)
                        {
                            c1->pos.y=t+c1->rayon;
                            c1->applyCollision(c1->pos,((CCollideMv*)c1)->vel,0.1,((CCollideMv*)c1)->masse,1);
                        }
                    }
                    t=((CCollideMv*)c1)->ffrot;
                    forceFrotement(((CCollideMv*)c1)->vel.x,t,cutElapsedTime);
                    forceFrotement(((CCollideMv*)c1)->vel.y,t,cutElapsedTime);
                    forceFrotement(((CCollideMv*)c1)->vel.z,t,cutElapsedTime);
                    v1=((CCollideMv*)c1)->force;
                    v1*=cutElapsedTime;
                    ((CCollideMv*)c1)->vel+=v1;
                    ((CCollideMv*)c1)->vel.y-=gravity*cutElapsedTime;
                    //v1=((CCollideMv*)c1)->vel;
                    //v1*=cutElapsedTime;
                }
                it++;
            }
        }
        
        iExp=vectExplo.begin();
        mexp=vectExplo.end();
        while(iExp!=mexp)
        {
            ed=*iExp;
            if(ed->life>cutElapsedTime)
            {
                ed->life-=cutElapsedTime;
                if(ed->frameMove(cutElapsedTime))
                {
                    delete ed;
                    vectExplo.erase(iExp);
                    mexp=vectExplo.end();
                }
                else iExp++;
            }
            else
            {
                delete ed;
                vectExplo.erase(iExp);
                mexp=vectExplo.end();
            }
        }
        
        it=vectColl.begin();
        mx=vectColl.end();
        while(it!=mx)
        {
            c1=*it;
            
            if(c1->frameMove(cutElapsedTime))
            {
                if(!(c1->colid_flags & IS_REF))delete c1;
                vectColl.erase(it);
                mx=vectColl.end();
            }
            else 
            {
                if(c1->isNotFixed)
                {
                    if(tr)
                    {
                        t=tr->getHeight(c1->pos.x,c1->pos.z);
                        if((c1->pos.y-c1->rayon)<t)
                        {
                            c1->pos.y=t+c1->rayon;
                            c1->applyCollision(c1->pos,((CCollideMv*)c1)->vel,0.1,((CCollideMv*)c1)->masse,1);
                        }
                    }
                    t=((CCollideMv*)c1)->ffrot;
                    forceFrotement(((CCollideMv*)c1)->vel.x,t,cutElapsedTime);
                    forceFrotement(((CCollideMv*)c1)->vel.y,t,cutElapsedTime);
                    forceFrotement(((CCollideMv*)c1)->vel.z,t,cutElapsedTime);
                    v1=((CCollideMv*)c1)->force;
                    v1*=cutElapsedTime;
                    ((CCollideMv*)c1)->vel+=v1;
                    ((CCollideMv*)c1)->vel.y-=gravity*cutElapsedTime;
                    //v1=((CCollideMv*)c1)->vel;
                    //v1*=cutElapsedTime;
                }
                it++;
            }
        }
        
    }//while 1
    
    //Ajout des collides ajouts pendant la MAJ
    //en effet si l'on ajoute un collides alors que l'on parcour le vecteur
    //qui rcupre ce mme collide cela cre des problmes.
    //Tout collide ajout durant le frameMove moteur est ajout dans un vecteur temporaire
    //avant d'tre transfr  la fin dans les listes du moteur pour le prochain frameMove.
    it=vectCollTT.begin();
    mx=vectCollTT.end();
    while(it!=mx)
    {
        vectColl.push_back(*it);
        it++;
    }
    vectCollTT.clear();
    
    iExp=vectExploTT.begin();
    mexp=vectExploTT.end();
    while(iExp!=mexp)
    {
        vectExplo.push_back(*iExp);
        iExp++;
    }
    vectExploTT.clear();
}

//rendu des objets non trensparent
void CMoteurCollide::render(float posix)
{
    vector<CCollide*>::iterator it;
    for(it=vectColl.begin();it!=vectColl.end();it++)
    {
        ((*it)->pos.z)-=posix;
        (*it)->render();
    }
}

//Rendu des lader et explosions
void CMoteurCollide::renderTransparent(float posix)
{
    glEnable(GL_BLEND);
    glDepthMask(GL_FALSE);
    glBlendFunc(GL_SRC_ALPHA,GL_ONE);//LIGHT
    
    vector<CExplosion*>::iterator iExp;
    for(iExp=vectExplo.begin();iExp!=vectExplo.end();iExp++)
    {
        ((*iExp)->pos.z)-=posix;
        (*iExp)->render();
    }
    
    vector<CCollide*>::iterator it;
    for(it=vectLsr.begin();it!=vectLsr.end();it++)
    {
        ((*it)->pos.z)-=posix;
        (*it)->render();
    }
    
    glDepthMask(GL_TRUE);
    glDisable(GL_BLEND);
}

void CMoteurCollide::addCollide(CCollide *cld)
{
    if(cld)vectColl.push_back(cld);
}

void CMoteurCollide::addCollideSf(CCollide *cld)
{
    if(cld)vectCollTT.push_back(cld);
}

void CMoteurCollide::addExplosion(CExplosion *cld)
{
    if(cld)vectExploTT.push_back(cld);
}

void CMoteurCollide::addLaser(CCollide *cld)
{
    if(cld)vectLsr.push_back(cld);
}

void CMoteurCollide::setGravity(float gravity)
{
    this->gravity=gravity;
}

void CMoteurCollide::setTerrain(CTerrainSplited *tr)
{
    this->tr=tr;
}

//Pour les missiles  tte chercheuse.
//si il est possible de calculer un point d'impact entre me (projectil)
//et un collides  proximit dans un certain champ de vision coefAct
//alors d est modifi et contiendra la direction  prendre et la fonction retournera true.
bool CMoteurCollide::getDirSearchingHead(CCollide *me,Vecteur &d,float sqrDistAct,float coefAct,float projSpeed)
{
    CCollide *trg=NULL,*cl;
    
    vector<CCollide*>::iterator it,mx;
    mx=vectColl.end();
    
    float fl;
    Vecteur p;
    
    for(it=vectColl.begin();it!=mx;it++)//On ne chercge que dans les collides non blend
    {
        cl=*it;
        if(cl && cl!=me && (cl->colid_flags & IN_LIFE))
        {
            p=cl->pos;
            p-=me->pos;
            fl=p.length2();
            
            if(fl<=sqrDistAct && fl>0.0)
            {
                sqrDistAct=fl;
                fl=sqrtf(fl);
                p/=fl;
                fl=p*d;
                if(fl>=coefAct)
                {
                    fl=coefAct;
                    trg=cl;
                }
            }
        }
    }
    
    if(trg)//Si target alors enticiper a trajectoire
    {
        p=trg->pos;
        p-=me->pos;
        
        Vecteur v;
        
        if(cl->isNotFixed)v=((CCollideMv*)cl)->vel;
        if(me->isNotFixed)v-=((CCollideMv*)me)->vel;
        
        float a,b,delta;
        
        a=(v*v-projSpeed*projSpeed);
        
        if(a==0.0)
        {
            p.normalize();
            d=p;
            return true;
        }
        
        b=(p*v);
        
        delta=b*b-a*(p*p);
        
        if(delta<0.0)
        {
            p.normalize();
            d=p;
            return true;
        }
        
        if(delta==0)a=-b/a;
        else a=-(b+sqrtf(delta))/a;
        
        v*=a;
        p+=v;
        
        p.normalize();
        d=p;
        
        return true;
    }
    
    return false;
}
